/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
 */
#ifndef BEST_H_
#define BEST_H_

#include <cstdint>
#include <string>
#include <vector>

#define BEST_API_PUBLIC __attribute__((visibility("default")))

#ifdef __cplusplus
extern "C" {
#endif

BEST_API_PUBLIC extern bool NUMA_ENABLED;
BEST_API_PUBLIC extern int num_numa_nodes;

class BestImpl;

class KBest {
   public:
    BEST_API_PUBLIC KBest(int K_features, int R, int L, int A, int graph_opt_iter, const std::string& metric,
                          const std::string& init_builder_type, const std::string& index_type);
    BEST_API_PUBLIC KBest(int K_features, int R, int L, int A, const char *metric, const std::string& init_builder_type); // 与之前版本保持兼容性
    BEST_API_PUBLIC KBest();
    BEST_API_PUBLIC int Add(int n, const float *x, int consecutive, int level); // 与之前版本保持兼容性
    BEST_API_PUBLIC int Add(int n, const float *x, int consecutive, int reorder, int level);
    BEST_API_PUBLIC int BuildSearcher();
    BEST_API_PUBLIC int Search(int n, const float* x, int k, float* distances, int64_t* labels, int num_thread);
    BEST_API_PUBLIC int Save(const char *path) const; // 将searcher + 原始数据落盘, 功能与Serialize一致
    BEST_API_PUBLIC int Load(const char *path);
    BEST_API_PUBLIC int Serialize(uint8_t *&dataPtr, size_t &dataLength) const; // 将searcher + 原始数据序列化
    BEST_API_PUBLIC int Deserialize(const uint8_t *dataPtr, const size_t &dataLength);
    BEST_API_PUBLIC int SaveGraph(const char *path) const; // 仅将图索引 + 原始数据落盘
    BEST_API_PUBLIC int LoadGraph(const char *path, int level = -1);
    BEST_API_PUBLIC int SetEf(int ef);
    BEST_API_PUBLIC int SetEarlyStoppingParams(int32_t adding_pref, int32_t patience);
    BEST_API_PUBLIC int GetNTotal() const;
    BEST_API_PUBLIC int GetDim() const;
    
    BEST_API_PUBLIC ~KBest();

   private:
    BestImpl *impl = nullptr;
    std::vector<BestImpl *> numaImpl;
    int hardwareNumThreads;
    int kbestDataNum;
};

#ifdef __cplusplus
}
#endif
#endif
